/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.world.level.storage.WorldData;
import org.slf4j.Logger;

public class ReloadCommand {
    private static final Logger f_138220_ = LogUtils.getLogger();

    public static void m_138235_(Collection<String> p_138236_, CommandSourceStack p_138237_) {
        p_138237_.m_81377_().m_129861_(p_138236_).exceptionally(p_138234_ -> {
            f_138220_.warn("Failed to execute reload", p_138234_);
            p_138237_.m_81352_((Component)((Object)new TranslatableComponent("commands.reload.failure")));
            return null;
        });
    }

    private static Collection<String> m_138222_(PackRepository p_138223_, WorldData p_138224_, Collection<String> p_138225_) {
        p_138223_.m_10506_();
        ArrayList collection = Lists.newArrayList(p_138225_);
        List<String> collection1 = p_138224_.m_7513_().m_45855_();
        for (String s : p_138223_.m_10514_()) {
            if (collection1.contains(s) || collection.contains(s)) continue;
            collection.add(s);
        }
        return collection;
    }

    public static void m_138226_(CommandDispatcher<CommandSourceStack> p_138227_) {
        p_138227_.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_("reload").requires(p_138231_ -> p_138231_.m_6761_(2))).executes(p_138229_ -> {
            CommandSourceStack commandsourcestack = (CommandSourceStack)p_138229_.getSource();
            MinecraftServer minecraftserver = commandsourcestack.m_81377_();
            PackRepository packrepository = minecraftserver.m_129891_();
            WorldData worlddata = minecraftserver.m_129910_();
            Collection<String> collection = packrepository.m_10523_();
            Collection<String> collection1 = ReloadCommand.m_138222_(packrepository, worlddata, collection);
            commandsourcestack.m_81354_((Component)((Object)new TranslatableComponent("commands.reload.success")), true);
            ReloadCommand.m_138235_(collection1, commandsourcestack);
            return 0;
        }));
    }

    public static void reload(MinecraftServer minecraftserver) {
        PackRepository resourcepackrepository = minecraftserver.m_129891_();
        WorldData savedata = minecraftserver.m_129910_();
        Collection<String> collection = resourcepackrepository.m_10523_();
        Collection<String> collection1 = ReloadCommand.m_138222_(resourcepackrepository, savedata, collection);
        minecraftserver.m_129861_(collection1);
    }
}

